'==========================================================================
' NAME:	IISProvisioning.vbs	 
'
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'
'==========================================================================



Public Function CreateWebSite(strComputer,strHostHeader,strIP,strPort,strIUSR,strPass,strWebPath,strLogPath,strDomain)
'==========================================================================
'	NAME:		CreateWebSite
'	INPUTS:		strComputer - NETBios name of the computer to provision
'				strHostHeader - Host Header name of the	web site.
'				strIP - IP Address of the Front Facing NIC
'				strPort - Port address (default assumes 80)
'				strIUSR - Anonymous user account for site
'				strPass - Anonymous User password
'	OUTPUT:		Return Code
'
'	COMMENTS:	This is the main wrapper function for provisioning a 
'				customer web site
'==========================================================================
	'Declare Variable
	Dim oLocator
	Dim oProvider
	Dim oService
	Dim arrBindings
	Dim strSiteObjPath
	Dim oPath
	Dim strSitePath
	Dim oVDir
	Dim strSiteID
	
	' Make connections to WMI, to the IIS namespace on MyMachine, and to the Web service. 
	Set oLocator = CreateObject("WbemScripting.SWbemLocator") 
	Set oProvider = oLocator.ConnectServer(strComputer, "root/MicrosoftIISv2") 
	set oService = oProvider.Get("IIsWebService='W3SVC'") 
	
	' Build binding object, which is a required parameter of the CreateNewSite method. 
	' Use the SpawnInstance WMI method since we are creating a new instance of an object. 
	arrBindings = Array(0) 
	Set arrBindings(0) = oProvider.get("ServerBinding").SpawnInstance_() 
	arrBindings(0).IP = strIP 
	arrBindings(0).Port = strPort
	arrBindings(0).Hostname = strHostHeader
	
	' Create the new Web site using the CreateNewSite method of the IIsWebService object. 
	strSiteObjPath = oService.CreateNewSite(strHostHeader, arrBindings, strWebPath) 
	WScript.Echo strSiteObjPath
	If Err Then 
		Write oLogFile, "Error Creating Site: " & Hex(Err.Number) & ": " & Err.Description & ". Script Aborting.",Err_FAIL,bDebug 
		Finalize, oLogFile,tStart
		WScript.Quit
	End If 
	' strSiteObjPath is in the format of IIsWebServer='W3SVC/1180970907' 
			' To parse out the absolute path, W3SVC/1180970907, use the SWbemObjectPath WMI object. 
	Set oPath = CreateObject("WbemScripting.SWbemObjectPath") 
	oPath.Path = strSiteObjPath 
	strSitePath = oPath.Keys.Item("") 
	' Set some properties on the root virtual directory which was created by CreateNewSite. 
	Set oVDir = oProvider.Get("IIsWebVirtualDirSetting='" & strSitePath & "/ROOT'") 
	oVDir.AuthFlags = 3 ' Basic + AuthAnonymous
	oVDir.AnonymousUserName = strDomain & "\" & StrIUSR
	oVDir.AnonymousUserPass = strPass
	oVDir.DefaultDoc = oVDir.DefaultDoc
	oVDir.EnableDefaultDoc = True 
	oVDir.DirBrowseFlags = &H4000003E ' date, time, size, extension, longdate 
	WScript.Echo "AccessFlags: " & oVDir.AccessFlags
	oVDir.AccessFlags = 513 ' read, script 
	WScript.Echo "AccessFlags: " & oVDir.AccessFlags
	oVDir.AppFriendlyName = strHostHeader
	' Save the new settings to the metabase 
	oVDir.Put_() 
	
	'Set the LogFile Properties
	Set oWService = oProvider.Get("IIsWebServerSetting='" & strSitePath & "'")
	oWService.LogFileDirectory = strLogPath
	oWService.LogExtFileFlags = 4194303
	oWService.Put_()
	

	' CreateNewSite does not start the server, so start it now. 
	Set oService = oProvider.Get(strSiteObjPath) 
	oService.Start 
	strSiteID = Split(strSitePath,"/",-1)
	CreateWebSite = strSiteID(1)

End Function

Public Sub FPSEExtend(strHH,strPort,strComputer,strAdmin)
'===================================================================
'	NAME: FPSEExtend
'	INPUTS:	strHH - Host Header name of site to extend
'			strPort - Port number for site
'			strComputer - NETBios name of Web Server
'			strAdmin - Name of Admin User
'	OUT:	None
'	COMMENTS: The subroutine extends the web site for use With
'				Frontpage.
'=====================================================================
' to extend the website with FPSE we need to use OWSADM.EXE because
	' FPSE 2002 does not offer an object modes to manage sites.
	' OWSADM.EXE is always at the location below so it is OK to Hardcode the Path.

	Dim strCmd
	Dim oExec
	strCmd = "cmd.exe /c ""C:\Program Files\Common Files\Microsoft Shared\web server extensions\50\bin\owsadm.exe"" -o " & _
			  "install -p " & strPort & " -m " & strHH & " -t msiis -u " & strComputer & "\" & strAdmin
	Set oExec = WshShell.Exec(strCmd)
	Do While Not oExec.StdOut.AtEndOfStream
		If Trim(oExec.StdOut.ReadLine) <> "" then
			write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
		End If
	Loop



End Sub

Public Sub MailCreate(strCustomer,strComputer,strAdminUser)
' **********************************************************
' Sub MailCreate()
' Description: 	sub routine to create the POP3 mailbox 
'				and the SMTP domain
'
' In:  none
' Out: none
' **********************************************************
	' to create the mailbox and the SMTP Domain we are 
	' using the WINPOP.EXE Commandline tool that ships
	' with Windows Server 2003 and is installed when 
	' the POP3 service is installed
	Dim strCmd
	Dim oExec
	Write oLogFile,"Creating MailDomain: " & strCustomer,Err_INFO,bDebug
	Write oLogFile,"MailServer: " & strComputer,Err_INFO,bDebug
	' Build the commandline to create the domain
	strCmd = "cmd.exe /c winpop.exe add " & strCustomer
	Set oExec = WshShell.Exec(strCmd)

	Do While Not oExec.StdOut.AtEndOfStream
		If Trim(oExec.StdOut.ReadLine) <> "" then
			write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
		End If
	Loop
	'Create the mailbox for the Admin user
	' Create the commandline for local users
	write oLogFile,"Creating MailBox For user " & strAdminUser,Err_INFO,bDebug
	write oLogFile,"MailServer: " & strComputer,Err_INFO,bDebug
	strCmd = "cmd.exe /c winpop.exe add " & strAdminUser & "@" & strCustomer
	Set oExec = WshShell.Exec(strCmd)
	Do While Not oExec.StdOut.AtEndOfStream
		If Trim(oExec.StdOut.ReadLine) <> "" then
			write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
		End If
	Loop
End Sub

Public Function CreateFTPVdir(strFtp,strPath,strAdminUser)
'==========================================================================
'	NAME:		CreateFTPVdir
'	INPUTS:		strFtp - name of the FTP site to create the vdir under
'				strPath - Web content physical directory ofr customer
'				strAdminUser - Name of the Customer Admin User

'	OUTPUT:		Metabase path to new vdir
'
'	COMMENTS:	This is the main wrapper function for provisioning a 
'				customer Ftp Vdir
'==========================================================================
	Dim oLocator
	Dim oProvider
	Dim oService
	Dim oItem
	Dim strSitePath
	Dim strNewVdir
	
	' Make connections to WMI, to the IIS namespace on MyMachine, and to the Web service. 
	Set oLocator = CreateObject("WbemScripting.SWbemLocator") 
	Set oProvider = oLocator.ConnectServer(strComputer, "root/MicrosoftIISv2") 
	set oService = oProvider.ExecQuery("SELECT Name FROM IIsFtpServerSetting WHERE ServerComment = '" & strFtp & "'")
	For Each oItem In oService
		strSitePath = oItem.Name
	Next
	strNewVdir = strSitePath & "/ROOT/ftp." & strAdminUser
	
	Set oService = oProvider.Get("IIsFtpVirtualDirSetting")
	Set oVdir = oService.SpawnInstance_()
	oVdir.Name = strNewVdir
	oVdir.Path = strPath
	oVdir.AccessFlags=1
	oVdir.Put_()
	
	CreateFTPVdir = oVdir.Name


End Function